<?php

/* -----------------------------------------------------------------
 * 	$Id: gimahhot.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Gimahhot {

    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;

    function Gimahhot() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'selling';
        $this->v_module_name = 'Gimahhot.de';
        $this->v_module_homepage = 'www.gimahhot.de';
        $this->v_module_format = 'csv';
        $this->v_module_export_filename = 'gimahhot.csv';
        $this->v_filename = 'gimahhot.php';
        $this->v_keyname = 'GIMAHHOT';
        $this->v_linkname = 'gimahhot';
        $this->v_delimiter = ';';
        $this->v_enclosure = '"';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = true;
        $this->v_field_shipping_costs_free = true;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;
    }

    function formAddOn() {
        
    }

    function formatResults($p_products_array) {
        $p_products_array['products_quantity'] = (int) $p_products_array['products_quantity'];
        $p_products_array['products_price'] = number_format((double) $p_products_array['products_price'], 2, ',', '');
        $p_products_array['products_shipping_costs'] = number_format((double) $p_products_array['products_shipping_costs'], 2, ',', '');
        $t_categories = explode(' > ', $p_products_array['products_categories']);
        $p_products_array['products_category_1'] = $t_categories[0];
        $p_products_array['products_category_2'] = $t_categories[1];
        $p_products_array['products_category_3'] = $t_categories[2];
        $p_products_array['products_category_4'] = $t_categories[3];
        $p_products_array['products_category_5'] = $t_categories[4];
        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_category_1'] = 'Kategorie1';
        $t_csv_fields_array['products_category_2'] = 'Kategorie2';
        $t_csv_fields_array['products_category_3'] = 'Kategorie3';
        $t_csv_fields_array['products_category_4'] = 'Kategorie4';
        $t_csv_fields_array['products_category_5'] = 'Kategorie5';
        $t_csv_fields_array['products_name'] = 'Produktname';
        $t_csv_fields_array['manufacturers_name'] = 'Hersteller';
        $t_csv_fields_array['products_model'] = 'Herstellernummer';
        $t_csv_fields_array['products_ean'] = 'EAN';
        $t_csv_fields_array['products_quantity'] = 'Stueckzahl';
        $t_csv_fields_array['products_price'] = 'Preis';
        $t_csv_fields_array['products_shipping_costs'] = 'Versandkosten';
        $t_csv_fields_array['products_id'] = 'offerid';
        $t_csv_fields_array['products_description'] = 'Beschreibung';
        $t_csv_fields_array['products_image_1'] = 'ImageURL';
        $t_csv_fields_array['products_retailprice'] = 'UvP';
        return($t_csv_fields_array);
    }

}

?>